/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.ui.CaseSensitiveFileNameExtensionFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.url.UrlManager;

class ExportBranchesToHTML
implements IExportEngine {
    @Override
    public void export(List<NodeModel> branches, File file) {
        try {
            MapClipboardController.getController().saveHTML(branches, file);
            ((UrlManager)Controller.getCurrentModeController().getExtension(UrlManager.class)).loadHyperlink(new Hyperlink(file.toURI()));
        }
        catch (IOException ex) {
            LogUtils.warn((Throwable)ex);
            UITools.errorMessage((Object)TextUtils.getText((String)"export_failed"));
        }
    }

    public FileFilter getFileFilter() {
        return new CaseSensitiveFileNameExtensionFilter("html", TextUtils.getText((String)"ExportBranchToHTMLAction.text"));
    }
}

