/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodelocation.mindmapmode;

import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodelocation.LocationModel;

class ChangeBaseHGapActor
implements IActor {
    private final NodeModel node;
    private final Quantity<LengthUnit> oldBaseHgap;
    private final Quantity<LengthUnit> baseHgap;

    ChangeBaseHGapActor(NodeModel node, Quantity<LengthUnit> baseHgap) {
        LocationModel locationModel = LocationModel.getModel((NodeModel)node);
        this.oldBaseHgap = locationModel.getBaseHGap();
        this.node = node;
        this.baseHgap = baseHgap;
    }

    public void act() {
        this.setBaseHgap(this.node, this.baseHgap);
    }

    public String getDescription() {
        return "changeBaseHHap";
    }

    private void setBaseHgap(NodeModel node, Quantity<LengthUnit> baseHgap) {
        LocationModel oldModel = LocationModel.getModel((NodeModel)node);
        Quantity oldBaseHgap = oldModel.getBaseHGap();
        LocationModel changeableModel = LocationModel.createLocationModel((NodeModel)node);
        changeableModel.setBaseHGap(baseHgap);
        if (changeableModel != oldModel || !baseHgap.equals((Object)oldBaseHgap)) {
            Controller.getCurrentModeController().getMapController().nodeChanged(node);
        }
    }

    public void undo() {
        this.setBaseHgap(this.node, this.oldBaseHgap);
    }
}

