/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode;

import java.util.ArrayList;
import java.util.LinkedList;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.NodeModel;

public class SelectionController {
    private final LinkedList<INodeSelectionListener> nodeSelectionListeners = new LinkedList();

    public void addNodeSelectionListener(INodeSelectionListener listener) {
        this.nodeSelectionListeners.add(listener);
    }

    public LinkedList<INodeSelectionListener> getNodeSelectionListeners() {
        return this.nodeSelectionListeners;
    }

    public void onDeselect(NodeModel node) {
        try {
            ArrayList<INodeSelectionListener> copy = new ArrayList<INodeSelectionListener>(this.nodeSelectionListeners);
            for (INodeSelectionListener listener : copy) {
                listener.onDeselect(node);
            }
        }
        catch (RuntimeException e) {
            LogUtils.severe("Error in node selection listeners", e);
        }
    }

    public void onSelect(NodeModel node) {
        ArrayList<INodeSelectionListener> copy = new ArrayList<INodeSelectionListener>(this.nodeSelectionListeners);
        for (INodeSelectionListener listener : copy) {
            listener.onSelect(node);
        }
    }

    public void removeNodeSelectionListener(INodeSelectionListener listener) {
        this.nodeSelectionListeners.remove(listener);
    }

    public void onSelectionChange(IMapSelection selection) {
        ArrayList<INodeSelectionListener> copy = new ArrayList<INodeSelectionListener>(this.nodeSelectionListeners);
        for (INodeSelectionListener listener : copy) {
            listener.onSelectionSetChange(selection);
        }
    }
}

