/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.DemangledVariable;
import ghidra.app.util.demangler.swift.SwiftDemangledNodeKind;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftDataTypeUtils;
import ghidra.app.util.demangler.swift.datatypes.SwiftFunction;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftGetterNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        Demangled demangled = null;
        String name = "get_";
        String callingConvention = "default";
        block4: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Subscript: {
                    demangled = child.demangle(demangler);
                    continue block4;
                }
                case Variable: {
                    demangled = child.demangle(demangler);
                    if (!child.hasChild(SwiftDemangledNodeKind.Class)) continue block4;
                    callingConvention = "__thiscall";
                    continue block4;
                }
            }
            this.skip(child);
        }
        if (demangled instanceof DemangledFunction) {
            DemangledFunction function = (DemangledFunction)demangled;
            function.setName(name + function.getName());
            function.setCallingConvention(callingConvention);
            return function;
        }
        if (demangled instanceof DemangledVariable) {
            DemangledVariable variable = (DemangledVariable)demangled;
            SwiftFunction function = new SwiftFunction(this.properties.mangled(), this.properties.originalDemangled(), name + variable.getName(), variable.getNamespace(), callingConvention);
            function.addParameters(SwiftDataTypeUtils.extractParameters(variable.getNamespace()));
            function.setReturnType(variable.getDataType());
            return function;
        }
        return this.getUnknown();
    }
}

