/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.equates.SarifEquateWriter;
import sarif.managers.SarifMgr;

public class EquatesSarifMgr
extends SarifMgr {
    public static String KEY = "EQUATES";
    public static String SUBKEY = "Equate";
    private EquateTable equateTable;

    EquatesSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
        this.equateTable = program.getEquateTable();
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws CancelledException {
        this.processEquate(result, monitor);
        return true;
    }

    private void processEquate(Map<String, Object> result, TaskMonitor monitor) {
        String name = (String)result.get("name");
        long value = (long)((Double)result.get("value")).doubleValue();
        try {
            this.equateTable.createEquate(name, value);
        }
        catch (DuplicateNameException e) {
            Equate eq = this.equateTable.getEquate(name);
            long prevVal = eq.getValue();
            if (prevVal != value) {
                this.log.appendMsg("Cannot create equate [" + name + "] with value [" + value + "]; previously defined with value [" + prevVal + "]");
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    void write(JsonArray results, AddressSetView set, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Writing EQUATES ...");
        ArrayList<Equate> request = new ArrayList<Equate>();
        Iterator iter = this.equateTable.getEquates();
        while (iter.hasNext()) {
            request.add((Equate)iter.next());
        }
        EquatesSarifMgr.writeAsSARIF(request, results);
    }

    public static void writeAsSARIF(List<Equate> request, JsonArray results) throws IOException {
        SarifEquateWriter writer = new SarifEquateWriter(request, null);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }
}

