/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.win32;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.io.ReadableRandomAccessStream;

public class WindowsLowLevelIO
implements ReadableRandomAccessStream {
    protected byte[] fileHandle;
    protected final int sectorSize;
    protected long filePointer = 0L;
    private static final Object loadLibSync = new Object();
    private static boolean libraryLoaded = false;
    public static boolean verboseLoadLibrary = false;

    private static ArchitectureIdentifier getJVMArchitecture() {
        String osArch = System.getProperty("os.arch");
        if (osArch.equalsIgnoreCase("x86") || osArch.equalsIgnoreCase("i386") || osArch.equalsIgnoreCase("i486") || osArch.equalsIgnoreCase("i586") || osArch.equalsIgnoreCase("i686")) {
            return ArchitectureIdentifier.I386;
        }
        if (osArch.equalsIgnoreCase("amd64") || osArch.equalsIgnoreCase("x86_64") || osArch.equalsIgnoreCase("x64")) {
            return ArchitectureIdentifier.AMD64;
        }
        if (osArch.equalsIgnoreCase("ia64") || osArch.equalsIgnoreCase("ia64n")) {
            return ArchitectureIdentifier.IA64;
        }
        return ArchitectureIdentifier.UNKNOWN;
    }

    public static boolean isSystemSupported() {
        ArchitectureIdentifier archId = WindowsLowLevelIO.getJVMArchitecture();
        return System.getProperty("os.name").toLowerCase().startsWith("windows") && (archId == ArchitectureIdentifier.I386 || archId == ArchitectureIdentifier.AMD64 || archId == ArchitectureIdentifier.IA64);
    }

    private static void loadLibrary() {
        ArchitectureIdentifier archId = WindowsLowLevelIO.getJVMArchitecture();
        if (archId == ArchitectureIdentifier.UNKNOWN) {
            System.err.println(System.getProperty("os.arch") + ": architecture unknown! Cannot locate appropriate native I/O library.");
            throw new RuntimeException("loadLibrary(): CPU architecture unknown!");
        }
        String libName = "llio_" + archId.getArchitectureString();
        try {
            if (verboseLoadLibrary) {
                System.err.println("Trying to load native library \"" + libName + "\"...");
            }
            System.loadLibrary(libName);
            if (verboseLoadLibrary) {
                System.err.println("Native library \"" + libName + "\" successfully loaded.");
            }
            libraryLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("ERROR: Native library \"" + libName + "\" failed to load!");
            System.err.println("java.library.path=\"" + System.getProperty("java.library.path") + "\"");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowsLowLevelIO(String filename) {
        Object object = loadLibSync;
        synchronized (object) {
            if (!libraryLoaded) {
                WindowsLowLevelIO.loadLibrary();
            }
        }
        boolean verbose = false;
        this.fileHandle = this.open(filename);
        int tmpSectorSize = WindowsLowLevelIO.getSectorSize(this.fileHandle);
        if (tmpSectorSize > 0) {
            if (verbose) {
                System.out.println("Sector size determined: " + tmpSectorSize);
            }
            this.sectorSize = tmpSectorSize;
        } else {
            if (verbose) {
                System.out.println("Could not determine sector size.");
            }
            this.sectorSize = 512;
        }
    }

    public void seek(long pos) {
        if (this.fileHandle == null) {
            throw new RuntimeException("File closed!");
        }
        WindowsLowLevelIO.seek(pos / (long)this.sectorSize * (long)this.sectorSize, this.fileHandle);
        this.filePointer = pos;
    }

    public int read() {
        byte[] oneByte = new byte[1];
        if (this.read(oneByte) == 1) {
            return oneByte[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] data) {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int pos, int len) {
        if (this.fileHandle != null) {
            WindowsLowLevelIO.seek(this.filePointer / (long)this.sectorSize * (long)this.sectorSize, this.fileHandle);
            long trueFp = WindowsLowLevelIO.getFilePointer(this.fileHandle);
            long fpDiff = this.filePointer - trueFp;
            if (fpDiff < 0L) {
                throw new RuntimeException("Program error: fpDiff < 0 (" + fpDiff + " < 0)");
            }
            if (fpDiff > (long)this.sectorSize) {
                throw new RuntimeException("Program error: fpDiff > sectorSize (" + fpDiff + " > " + this.sectorSize + ")");
            }
            int alignedLen = (int)fpDiff + len;
            byte[] tmp = new byte[(alignedLen / this.sectorSize + (alignedLen % this.sectorSize != 0 ? 1 : 0)) * this.sectorSize];
            int bytesRead = WindowsLowLevelIO.read(tmp, 0, tmp.length, this.fileHandle);
            bytesRead = bytesRead >= alignedLen ? len : bytesRead - (int)fpDiff;
            this.filePointer += (long)bytesRead;
            System.arraycopy(tmp, (int)fpDiff, data, pos, bytesRead);
            return bytesRead;
        }
        throw new RuntimeException("File closed!");
    }

    public void readFully(byte[] data) {
        this.readFully(data, 0, data.length);
    }

    public void readFully(byte[] data, int offset, int length) {
        if (this.fileHandle != null) {
            int curBytesRead;
            for (int bytesRead = 0; bytesRead < length; bytesRead += curBytesRead) {
                curBytesRead = this.read(data, offset + bytesRead, length - bytesRead);
                if (curBytesRead > 0) {
                    continue;
                }
                throw new RuntimeException("Couldn't read the entire length.");
            }
        } else {
            throw new RuntimeException("File closed!");
        }
    }

    public long length() {
        if (this.fileHandle != null) {
            return WindowsLowLevelIO.length(this.fileHandle);
        }
        throw new RuntimeException("File closed!");
    }

    public long getFilePointer() {
        if (this.fileHandle != null) {
            return this.filePointer;
        }
        throw new RuntimeException("File closed!");
    }

    public void close() {
        if (this.fileHandle == null) {
            throw new RuntimeException("File closed!");
        }
        WindowsLowLevelIO.close(this.fileHandle);
        this.fileHandle = null;
    }

    public void ejectMedia() {
        if (this.fileHandle == null) {
            throw new RuntimeException("File closed!");
        }
        WindowsLowLevelIO.ejectMedia(this.fileHandle);
    }

    public void loadMedia() {
        if (this.fileHandle == null) {
            throw new RuntimeException("File closed!");
        }
        WindowsLowLevelIO.loadMedia(this.fileHandle);
    }

    protected byte[] open(String filename) {
        return WindowsLowLevelIO.openNative(filename);
    }

    protected static native byte[] openNative(String var0);

    protected static native void seek(long var0, byte[] var2);

    protected static native int read(byte[] var0, int var1, int var2, byte[] var3);

    protected static native void close(byte[] var0);

    protected static native void ejectMedia(byte[] var0);

    protected static native void loadMedia(byte[] var0);

    protected static native long length(byte[] var0);

    protected static native long getFilePointer(byte[] var0);

    protected static native int getSectorSize(byte[] var0);

    public static void main(String[] args) {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        WindowsLowLevelIO wllio1 = new WindowsLowLevelIO(args[0]);
        try {
            if (args[1].equals("testread")) {
                System.out.println("Seeking to 1024...");
                wllio1.seek(1024L);
                byte[] buf = new byte[4096];
                System.out.println("Reading " + buf.length + " bytes from file: ");
                int bytesRead = wllio1.read(buf);
                System.out.println(" Bytes read: " + bytesRead);
                System.out.println(" As hex:    0x" + Util.byteArrayToHexString(buf));
                System.out.println(" As string: \"" + new String(buf, "US-ASCII") + "\"");
            } else if (args[1].equals("eject")) {
                System.out.print("Press any key to eject media...");
                stdin.readLine();
                wllio1.ejectMedia();
                System.out.print("Press any key to load media...");
                stdin.readLine();
                wllio1.loadMedia();
            } else {
                System.out.println("Nothing to do.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        wllio1.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ArchitectureIdentifier {
        I386("i386"),
        AMD64("amd64"),
        IA64("ia64"),
        POWERPC("ppc32"),
        POWERPC64("ppc64"),
        SPARC("sparc32"),
        SPARC64("sparc64"),
        MIPS("mips32"),
        MIPS64("mips64"),
        ALPHA("alpha"),
        UNKNOWN;

        private final String idString;

        private ArchitectureIdentifier() {
            this.idString = null;
        }

        private ArchitectureIdentifier(String idString) {
            this.idString = idString;
        }

        public String getArchitectureString() {
            return this.idString;
        }
    }
}

