/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.gui.filters.BSimValueEditor;
import ghidra.util.Swing;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import utility.function.Callback;

public class BooleanBSimValueEditor
implements BSimValueEditor {
    private Callback listener;
    private JRadioButton trueButton;
    private JRadioButton falseButton;
    private BSimFilterType filterType;
    private JPanel component;

    public BooleanBSimValueEditor(BSimFilterType filterType, List<String> initialValues, Callback listener) {
        this.filterType = filterType;
        this.listener = listener;
        this.component = this.createInputPanel();
        this.setValues(initialValues);
    }

    private void setValue(String value) {
        if ("true".equals(value = this.filterType.normalizeValue(value))) {
            this.trueButton.setSelected(true);
        } else if ("false".equals(value)) {
            this.falseButton.setSelected(true);
        }
    }

    @Override
    public void setValues(List<String> values) {
        String value = "true";
        if (values != null && !values.isEmpty()) {
            value = values.get(0);
        }
        this.setValue(value);
    }

    @Override
    public List<String> getValues() {
        if (this.trueButton.isSelected()) {
            return List.of("true");
        }
        return List.of("false");
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    private void valueChanged() {
        Swing.runLater(() -> this.listener.call());
    }

    private JPanel createInputPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createEmptyBorder());
        this.trueButton = new JRadioButton("True");
        this.falseButton = new JRadioButton("False");
        ButtonGroup group = new ButtonGroup();
        group.add(this.trueButton);
        group.add(this.falseButton);
        this.trueButton.addActionListener(e -> this.valueChanged());
        this.falseButton.addActionListener(e -> this.valueChanged());
        panel.add(this.trueButton);
        panel.add(this.falseButton);
        this.setValue("true");
        return panel;
    }

    @Override
    public boolean hasValidValues() {
        return true;
    }
}

