/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api;

import ghidra.feature.vt.api.FunctionNode;
import ghidra.feature.vt.api.FunctionPair;

public class PotentialPair
implements Comparable<PotentialPair> {
    private FunctionPair originBridge;
    private FunctionNode fromNode;
    private FunctionNode toNode;
    private double score;
    public static final PotentialPair EMPTY_PAIR = new PotentialPair(null, null, 0.0);

    public PotentialPair(FunctionNode src, FunctionNode dest, double sc) {
        this.fromNode = src;
        this.toNode = dest;
        this.score = sc;
    }

    public double getScore() {
        return this.score;
    }

    public FunctionNode getSource() {
        return this.fromNode;
    }

    public FunctionNode getDestination() {
        return this.toNode;
    }

    public FunctionPair getOrigin() {
        return this.originBridge;
    }

    public void setOrigin(FunctionPair pair) {
        this.originBridge = pair;
    }

    public void swap() {
        FunctionNode tmp = this.fromNode;
        this.fromNode = this.toNode;
        this.toNode = tmp;
    }

    @Override
    public int compareTo(PotentialPair o) {
        return Double.compare(this.score, o.score);
    }
}

