/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.lifecycle.Unfinished;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.UnOpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitIntSExtOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum IntSExtOpGen implements UnOpGen<JitIntSExtOp>
{
    GEN;


    @Override
    public JitType generateUnOpRunCode(JitCodeGenerator gen, JitIntSExtOp op, JitControlFlowModel.JitBlock block, JitType uType, MethodVisitor rv) {
        JitType outType = op.type().resolve(gen.getTypeModel().typeOf(op.out()));
        if (uType == JitType.IntJitType.I4 && outType == JitType.LongJitType.I8) {
            rv.visitInsn(133);
            return outType;
        }
        TypeConversions.generate(gen, uType, outType, rv);
        JitType jitType = outType;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType t = (JitType.IntJitType)jitType2;
                int shamt = 32 - op.u().size() * 8;
                if (shamt == 0) break;
                rv.visitLdcInsn((Object)shamt);
                rv.visitInsn(120);
                rv.visitLdcInsn((Object)shamt);
                rv.visitInsn(122);
                break;
            }
            case 1: {
                JitType.LongJitType t = (JitType.LongJitType)jitType2;
                int shamt = 64 - op.u().size() * 8;
                if (shamt == 0) break;
                rv.visitLdcInsn((Object)shamt);
                rv.visitInsn(121);
                rv.visitLdcInsn((Object)shamt);
                rv.visitInsn(123);
                break;
            }
            case 2: {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                Unfinished.TODO((String)"MpInt", (Object[])new Object[0]);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return outType;
    }
}

