/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractUserDefinedTypeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.PdbNamespaceUtils;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DirectSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class TypedefSymbolApplier
extends MsSymbolApplier
implements DirectSymbolApplier {
    private DataType resolvedDataType = null;
    private AbstractUserDefinedTypeMsSymbol symbol;

    public TypedefSymbolApplier(DefaultPdbApplicator applicator, AbstractUserDefinedTypeMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    @Override
    public void apply(MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        this.resolvedDataType = this.applyUserDefinedTypeMsSymbol();
    }

    String getName() {
        return this.symbol.getName();
    }

    RecordNumber getTypeRecordNumber() {
        return this.symbol.getTypeRecordNumber();
    }

    DataType getResolvedDataType() throws PdbException {
        if (this.resolvedDataType == null) {
            throw new PdbException("Data type not resolved");
        }
        return this.resolvedDataType;
    }

    private DataType applyUserDefinedTypeMsSymbol() throws CancelledException, PdbException {
        String name = this.symbol.getName();
        RecordNumber typeRecordNumber = this.symbol.getTypeRecordNumber();
        AbstractMsType mType = this.applicator.getTypeRecord(typeRecordNumber);
        MsTypeApplier applier = this.applicator.getTypeApplier(typeRecordNumber);
        if (applier == null) {
            return null;
        }
        DataType dataType = this.applicator.getCompletedDataType(typeRecordNumber);
        if (dataType == null) {
            return null;
        }
        if (mType instanceof AbstractComplexMsType && name.equals(mType.getName())) {
            return dataType;
        }
        SymbolPath symbolPath = new SymbolPath(name);
        symbolPath = PdbNamespaceUtils.convertToGhidraPathName(symbolPath);
        CategoryPath categoryPath = this.applicator.getTypedefsCategory(this.applicator.getCurrentModuleNumber(), symbolPath);
        TypedefDataType typedef = new TypedefDataType(categoryPath.getParent(), categoryPath.getName(), dataType, this.applicator.getDataTypeManager());
        return this.applicator.resolve((DataType)typedef);
    }

    private AbstractUserDefinedTypeMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof AbstractUserDefinedTypeMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        AbstractUserDefinedTypeMsSymbol udtSymbol = (AbstractUserDefinedTypeMsSymbol)abstractSymbol;
        return udtSymbol;
    }
}

