/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver.ui;

import ghidra.util.task.TaskMonitor;
import pdb.symbolserver.DisabledSymbolServer;
import pdb.symbolserver.SymbolServer;

class SymbolServerRow {
    private SymbolServer symbolServer;
    private LocationStatus status = LocationStatus.UNKNOWN;

    SymbolServerRow(SymbolServer symbolServer) {
        this.symbolServer = symbolServer;
    }

    SymbolServer getSymbolServer() {
        return this.symbolServer;
    }

    void setSymbolServer(SymbolServer symbolServer) {
        this.symbolServer = symbolServer;
    }

    boolean isEnabled() {
        return !(this.symbolServer instanceof DisabledSymbolServer);
    }

    void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        if (enabled) {
            DisabledSymbolServer dss = (DisabledSymbolServer)this.symbolServer;
            this.symbolServer = dss.getSymbolServer();
        } else {
            this.symbolServer = new DisabledSymbolServer(this.symbolServer);
        }
    }

    boolean isTrusted() {
        return this.symbolServer.isTrusted();
    }

    void setTrusted(boolean isTrusted) {
        SymbolServer symbolServer = this.symbolServer;
        if (symbolServer instanceof SymbolServer.MutableTrust) {
            SymbolServer.MutableTrust sswt = (SymbolServer.MutableTrust)((Object)symbolServer);
            sswt.setTrusted(isTrusted);
        }
    }

    LocationStatus getStatus() {
        return this.status;
    }

    void setStatus(LocationStatus status) {
        this.status = status;
    }

    void updateStatus(TaskMonitor monitor) {
        if (!(this.symbolServer instanceof SymbolServer.StatusRequiresContext)) {
            this.status = this.symbolServer.isValid(monitor) ? LocationStatus.VALID : LocationStatus.INVALID;
        }
    }

    public String toString() {
        return String.format("SymbolServerRow: [ status: %s, server: %s]", this.status.toString(), this.symbolServer.toString());
    }

    public static enum LocationStatus {
        UNKNOWN,
        VALID,
        INVALID;

    }
}

