/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art.headers;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.art.ArtHeader;
import ghidra.file.formats.android.art.ArtImageSections;
import ghidra.file.formats.android.art.ArtImageSectionsFactory;
import ghidra.file.formats.android.art.image_method.ImageMethod_Marshmallow;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class ArtHeader_017
extends ArtHeader {
    protected int image_begin_;
    protected int image_size_;
    protected int oat_checksum_;
    protected int oat_file_begin_;
    protected int oat_data_begin_;
    protected int oat_data_end_;
    protected int oat_file_end_;
    protected int patch_delta_;
    protected int image_roots_;
    protected int pointer_size_;
    protected int compile_pic_;
    protected long[] image_methods_ = new long[ImageMethod_Marshmallow.kImageMethodsCount.ordinal()];
    protected ArtImageSections sections;

    public ArtHeader_017(BinaryReader reader) throws IOException {
        super(reader);
        this.parse(reader);
    }

    @Override
    protected void parse(BinaryReader reader) throws IOException {
        this.image_begin_ = reader.readNextInt();
        this.image_size_ = reader.readNextInt();
        this.oat_checksum_ = reader.readNextInt();
        this.oat_file_begin_ = reader.readNextInt();
        this.oat_data_begin_ = reader.readNextInt();
        this.oat_data_end_ = reader.readNextInt();
        this.oat_file_end_ = reader.readNextInt();
        this.patch_delta_ = reader.readNextInt();
        this.image_roots_ = reader.readNextInt();
        this.pointer_size_ = reader.readNextInt();
        this.compile_pic_ = reader.readNextInt();
        this.sections = ArtImageSectionsFactory.getArtImageSections(reader, this);
        this.sections.parseSections(reader);
        for (int i = 0; i < this.image_methods_.length; ++i) {
            this.image_methods_[i] = reader.readNextLong();
        }
        this.sections.parse(reader);
    }

    @Override
    public int getImageBegin() {
        return this.image_begin_;
    }

    @Override
    public int getImageSize() {
        return this.image_size_;
    }

    @Override
    public int getPointerSize() {
        return this.pointer_size_;
    }

    public long[] getImageMethods() {
        return this.image_methods_;
    }

    @Override
    public int getOatChecksum() {
        return this.oat_checksum_;
    }

    @Override
    public int getOatFileBegin() {
        return this.oat_file_begin_;
    }

    @Override
    public int getOatFileEnd() {
        return this.oat_file_end_;
    }

    @Override
    public int getOatDataBegin() {
        return this.oat_data_begin_;
    }

    @Override
    public int getOatDataEnd() {
        return this.oat_data_end_;
    }

    @Override
    public void markup(Program program, TaskMonitor monitor) throws Exception {
        this.sections.markup(program, monitor);
    }

    @Override
    public int getArtMethodCountForVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        int i;
        Structure structure = (Structure)super.toDataType();
        structure.add(DWORD, "image_begin_", null);
        structure.add(DWORD, "image_size_", null);
        structure.add(DWORD, "oat_checksum_", null);
        structure.add(DWORD, "oat_file_begin_", null);
        structure.add(DWORD, "oat_data_begin_", null);
        structure.add(DWORD, "oat_data_end_", null);
        structure.add(DWORD, "oat_file_end_", null);
        structure.add(DWORD, "patch_delta_", null);
        structure.add(DWORD, "image_roots_", null);
        structure.add(DWORD, "pointer_size_", null);
        structure.add(DWORD, "compile_pic_", null);
        for (i = 0; i < this.sections.getSectionList().size(); ++i) {
            structure.add(this.sections.getSectionList().get(i).toDataType(), "section_" + i, null);
        }
        for (i = 0; i < this.image_methods_.length; ++i) {
            structure.add(QWORD, "image_method_" + i, null);
        }
        return structure;
    }
}

