/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.mdmp.Module;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ModuleListStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_MODULE_LIST";
    private int numberOfModules;
    private Module[] modules;
    private DumpFileReader reader;
    private long index;

    ModuleListStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setNumberOfModules(this.reader.readNextInt());
        this.modules = new Module[this.numberOfModules];
        for (int i = 0; i < this.numberOfModules; ++i) {
            this.setModule(new Module(this.reader, this.reader.getPointerIndex()), i);
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "NumberOfModules", null);
        DataType t = this.modules[0].toDataType();
        ArrayDataType a = new ArrayDataType(t, this.numberOfModules, t.getLength());
        struct.add((DataType)a, a.getLength(), "Modules", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public int getNumberOfModules() {
        return this.numberOfModules;
    }

    public void setNumberOfModules(int numberOfModules) {
        this.numberOfModules = numberOfModules;
    }

    public Module getModule(int idx) {
        return this.modules[idx];
    }

    public void setModule(Module module, int index) {
        this.modules[index] = module;
    }
}

