/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img3.tag;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProviderPaddedInputStream;
import ghidra.file.crypto.CryptoKey;
import ghidra.file.crypto.CryptoKeyFactory;
import ghidra.file.formats.ios.generic.iOS_AesCrypto;
import ghidra.file.formats.ios.img3.AbstractImg3Tag;
import ghidra.util.exception.CryptoException;
import java.io.IOException;
import java.io.InputStream;

public class DataTag
extends AbstractImg3Tag {
    private long _dataStartIndex;

    DataTag(BinaryReader reader) throws IOException {
        super(reader);
        this._dataStartIndex = reader.getPointerIndex();
    }

    public byte[] getData() throws IOException {
        byte[] data = this._reader.readByteArray(this._dataStartIndex, this.dataLength);
        int remainder = data.length % 16;
        if (remainder == 0) {
            return data;
        }
        byte[] padded = new byte[data.length + (16 - remainder)];
        System.arraycopy(data, 0, padded, 0, data.length);
        return padded;
    }

    public long getLengthWithPadding() {
        int remainder = this.dataLength % 16;
        return this.dataLength + (16 - remainder);
    }

    public InputStream getDataAsInputStream() {
        return new ByteProviderPaddedInputStream(this._reader.getByteProvider(), this._dataStartIndex, (long)this.dataLength, (long)(16 - this.dataLength % 16));
    }

    public InputStream getDecryptedInputStream(String containerName, String img3Name) throws CryptoException {
        CryptoKey cryptoKey = CryptoKeyFactory.getCryptoKey(containerName, img3Name);
        if (cryptoKey == CryptoKey.NOT_ENCRYPTED_KEY) {
            return this.getDataAsInputStream();
        }
        iOS_AesCrypto aes = new iOS_AesCrypto(cryptoKey.key, cryptoKey.iv);
        return aes.decrypt(this.getDataAsInputStream());
    }
}

