/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeSlowLoadingNode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.calltree.CallTreeOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.apache.commons.collections4.map.LazyMap;
import resources.MultiIcon;
import resources.icons.TranslateIcon;

public abstract class CallNode
extends GTreeSlowLoadingNode {
    static final Icon FUNCTION_ICON = new GIcon("icon.plugin.calltree.function");
    static final Icon REFERENCE_ICON = new GIcon("icon.plugin.calltree.reference");
    static final Icon RECURSIVE_ICON = new GIcon("icon.plugin.calltree.recursive");
    protected CallTreeOptions callTreeOptions;
    private int depth = -1;
    protected boolean invalid = false;
    protected boolean isCallReference = false;

    protected static Icon createIcon(Icon baseIcon, boolean isCallReference) {
        MultiIcon multiIcon = new MultiIcon(baseIcon, false, 32, 16);
        TranslateIcon translateIcon = isCallReference ? new TranslateIcon(FUNCTION_ICON, 16, 0) : new TranslateIcon(REFERENCE_ICON, 16, 0);
        multiIcon.addIcon((Icon)translateIcon);
        return multiIcon;
    }

    public CallNode(CallTreeOptions callTreeOptions) {
        this.callTreeOptions = Objects.requireNonNull(callTreeOptions);
    }

    public abstract Function getRemoteFunction();

    public abstract ProgramLocation getLocation();

    public abstract Address getSourceAddress();

    abstract CallNode recreate();

    public boolean isCallReference() {
        return this.isCallReference;
    }

    public String getToolTip() {
        String refString = this.isCallReference ? "Called from " : "Referenced from ";
        return refString + String.valueOf(this.getSourceAddress());
    }

    protected void addNode(LazyMap<Function, List<GTreeNode>> nodesByFunction, CallNode nodeToAdd) {
        if (this.ignoreNonCallReference(nodeToAdd)) {
            return;
        }
        Function function = nodeToAdd.getRemoteFunction();
        List nodes = (List)nodesByFunction.get((Object)function);
        if (nodes.isEmpty()) {
            nodes.add(nodeToAdd);
            return;
        }
        for (GTreeNode node : nodes) {
            if (node.equals((Object)nodeToAdd)) {
                return;
            }
            CallNode existingNode = (CallNode)node;
            if (!this.resovleConflictingReferenceTypes(nodes, existingNode, nodeToAdd)) continue;
            return;
        }
        if (this.callTreeOptions.allowsDuplicates()) {
            nodes.add(nodeToAdd);
            return;
        }
    }

    private boolean ignoreNonCallReference(CallNode nodeToAdd) {
        if (nodeToAdd.isCallReference()) {
            return false;
        }
        return !this.callTreeOptions.allowsNonCallReferences();
    }

    private boolean resovleConflictingReferenceTypes(List<GTreeNode> nodes, CallNode existingNode, CallNode nodeToAdd) {
        Address exitingAddress;
        Address newAddress = nodeToAdd.getSourceAddress();
        if (!newAddress.equals((Object)(exitingAddress = existingNode.getSourceAddress()))) {
            return false;
        }
        if (nodeToAdd.isCallReference() == existingNode.isCallReference()) {
            return false;
        }
        if (!existingNode.isCallReference()) {
            nodes.remove((Object)existingNode);
            nodes.add((GTreeNode)nodeToAdd);
        }
        return true;
    }

    public int loadAll(TaskMonitor monitor) throws CancelledException {
        if (this.depth() > this.callTreeOptions.getRecurseDepth()) {
            return 1;
        }
        return super.loadAll(monitor);
    }

    private int depth() {
        if (this.depth < 0) {
            TreePath treePath = this.getTreePath();
            Object[] path = treePath.getPath();
            this.depth = path.length;
        }
        return this.depth;
    }

    boolean functionIsInPath() {
        Object[] pathComponents;
        TreePath path = this.getTreePath();
        for (Object pathComponent : pathComponents = path.getPath()) {
            CallNode node = (CallNode)((Object)pathComponent);
            Function nodeFunction = node.getRemoteFunction();
            Function myFunction = this.getRemoteFunction();
            if (node == this || !nodeFunction.equals((Object)myFunction)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CallNode other = (CallNode)((Object)obj);
        if (!Objects.equals(this.getSourceAddress(), other.getSourceAddress())) {
            return false;
        }
        if (other.isCallReference != this.isCallReference) {
            return false;
        }
        return Objects.equals(this.getRemoteFunction(), other.getRemoteFunction());
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Boolean.hashCode(this.isCallReference);
        Function function = this.getRemoteFunction();
        result = 31 * result + (function == null ? 0 : function.hashCode());
        Address sourceAddress = this.getSourceAddress();
        result = 31 * result + (sourceAddress == null ? 0 : sourceAddress.hashCode());
        return result;
    }

    protected class CallNodeComparator
    implements Comparator<GTreeNode> {
        protected CallNodeComparator(CallNode this$0) {
        }

        @Override
        public int compare(GTreeNode o1, GTreeNode o2) {
            CallNode node1 = (CallNode)o1;
            CallNode node2 = (CallNode)o2;
            int addrCompare = node1.getSourceAddress().compareTo((Object)node2.getSourceAddress());
            if (addrCompare != 0) {
                return addrCompare;
            }
            return Boolean.compare(node1.isCallReference, node2.isCallReference);
        }
    }
}

