/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.overview.addresstype;

import docking.widgets.label.GLabel;
import ghidra.app.plugin.core.overview.addresstype.AddressType;
import ghidra.app.plugin.core.overview.addresstype.AddressTypeOverviewColorService;
import ghidra.util.layout.PairLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

public class AddressTypeOverviewLegendPanel
extends JPanel {
    private static Dimension COLOR_SIZE = new Dimension(15, 15);
    private AddressTypeOverviewColorService colorService;

    public AddressTypeOverviewLegendPanel(AddressTypeOverviewColorService colorService) {
        this.colorService = colorService;
        this.setLayout((LayoutManager)new PairLayout(4, 10));
        this.setBorder(BorderFactory.createEmptyBorder(4, 20, 4, 30));
        this.buildLegend();
    }

    public void updateColors() {
        this.repaint();
    }

    private void buildLegend() {
        AddressType[] values;
        this.removeAll();
        for (AddressType addressType : values = AddressType.values()) {
            ColorPanel panel = new ColorPanel(addressType);
            this.add(panel);
            this.add((Component)new GLabel(addressType.getDescription()));
        }
    }

    private class ColorPanel
    extends JPanel {
        private AddressType type;

        ColorPanel(final AddressType type) {
            this.type = type;
            this.setPreferredSize(COLOR_SIZE);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Color newColor = JColorChooser.showDialog(ColorPanel.this, "Select Color", ColorPanel.this.getBackground());
                    AddressTypeOverviewLegendPanel.this.colorService.setColor(type, newColor);
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.setBackground(AddressTypeOverviewLegendPanel.this.colorService.getColor(this.type));
            super.paintComponent(g);
        }
    }
}

