/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.GoTypeManager;
import ghidra.app.util.bin.format.golang.rtti.types.GoBaseType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@StructureMapping(structureName={"runtime.functype", "internal/abi.FuncType"})
public class GoFuncType
extends GoType {
    @FieldMapping
    private int inCount;
    @FieldMapping
    private int outCount;

    public static FunctionDefinition unwrapFunctionDefinitionPtrs(DataType dt) {
        FunctionDefinition funcdef;
        Pointer funcdefPtr;
        Structure closureStructDT;
        Pointer ptrDT;
        DataType dataType;
        return dt != null && dt instanceof Pointer && (dataType = (ptrDT = (Pointer)dt).getDataType()) instanceof Structure && (closureStructDT = (Structure)dataType).getNumComponents() > 1 && (dataType = closureStructDT.getComponent(0).getDataType()) instanceof Pointer && (dataType = (funcdefPtr = (Pointer)dataType).getDataType()) instanceof FunctionDefinition ? (funcdef = (FunctionDefinition)dataType) : null;
    }

    public boolean isVarArg() {
        return (this.outCount & 0x8000) != 0;
    }

    public int getInCount() {
        return this.inCount;
    }

    public int getOutCount() {
        return this.outCount & Short.MAX_VALUE;
    }

    public int getParamCount() {
        return this.inCount + (this.outCount & Short.MAX_VALUE);
    }

    private List<Address> getParamTypeAddrs() throws IOException {
        GoSlice slice = this.getParamListSlice();
        long[] typeOffsets = slice.readUIntList(this.programContext.getPtrSize());
        return Arrays.stream(typeOffsets).mapToObj(this.programContext::getDataAddress).toList();
    }

    private GoSlice getParamListSlice() {
        int count = this.getParamCount();
        return new GoSlice(this.getOffsetEndOfFullType(), count, count, this.programContext);
    }

    @Markup
    public List<GoType> getParamTypes() throws IOException {
        return this.getParamTypeAddrs().stream().map(addr -> this.programContext.getGoTypes().getTypeUnchecked((Address)addr)).toList();
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException, CancelledException {
        super.additionalMarkup(session);
        GoSlice slice = this.getParamListSlice();
        slice.markupArray(this.getStructureLabel() + "_paramlist", this.getStructureNamespace(), GoBaseType.class, true, session);
    }

    public String getFuncPrototypeString(String funcName) {
        funcName = funcName != null && !((String)funcName).isBlank() ? " " + (String)funcName : "";
        return "func%s%s".formatted(funcName, this.getParamListString());
    }

    public String getParamListString() {
        try {
            GoType paramType;
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            List<GoType> paramTypes = this.getParamTypes();
            List<GoType> inParamTypes = paramTypes.subList(0, this.inCount);
            List<GoType> outParamTypes = paramTypes.subList(this.inCount, paramTypes.size());
            for (i = 0; i < inParamTypes.size(); ++i) {
                paramType = inParamTypes.get(i);
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(paramType.getName());
            }
            sb.append(")");
            if (!outParamTypes.isEmpty()) {
                sb.append(" ");
                if (outParamTypes.size() > 1) {
                    sb.append("(");
                }
                for (i = 0; i < outParamTypes.size(); ++i) {
                    paramType = outParamTypes.get(i);
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(paramType.getName());
                }
                if (outParamTypes.size() > 1) {
                    sb.append(")");
                }
            }
            return sb.toString();
        }
        catch (IOException e) {
            return "(???)";
        }
    }

    public static String getMissingFuncPrototypeString(String funcName, String genericsString) {
        genericsString = genericsString == null || genericsString.isEmpty() ? "" : "[" + genericsString + "]";
        return "func %s%s(???)".formatted(funcName, genericsString);
    }

    @Override
    public DataType recoverDataType(GoTypeManager goTypes) throws IOException {
        VoidDataType returnDT;
        DataTypeManager dtm = goTypes.getDTM();
        String name = goTypes.getTypeName(this);
        CategoryPath cp = goTypes.getCP(this);
        StructureDataType struct = new StructureDataType(cp, name, (int)this.typ.getSize(), dtm);
        Pointer structPtr = dtm.getPointer((DataType)struct);
        FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(cp, name + "_F", dtm);
        struct.replace(0, (DataType)dtm.getPointer((DataType)funcDef), -1, "F", null);
        struct.add((DataType)new ArrayDataType(goTypes.getUint8DT(), 0), "context", null);
        struct.setToDefaultPacking();
        goTypes.cacheRecoveredDataType(this, (DataType)structPtr);
        List<GoType> paramTypes = this.getParamTypes();
        List<GoType> inParamTypes = paramTypes.subList(0, this.inCount);
        List<GoType> outParamTypes = paramTypes.subList(this.inCount, paramTypes.size());
        ArrayList<ParameterDefinitionImpl> params = new ArrayList<ParameterDefinitionImpl>();
        params.add(new ParameterDefinitionImpl(".context", (DataType)dtm.getPointer((DataType)struct), null));
        for (GoType paramType : inParamTypes) {
            DataType paramDT = goTypes.getGhidraDataType(paramType);
            params.add(new ParameterDefinitionImpl(null, paramDT, null));
        }
        if (outParamTypes.size() == 0) {
            returnDT = VoidDataType.dataType;
        } else if (outParamTypes.size() == 1) {
            returnDT = goTypes.getGhidraDataType(outParamTypes.get(0));
        } else {
            ArrayList<DataType> paramDataTypes = new ArrayList<DataType>();
            for (GoType outParamType : outParamTypes) {
                paramDataTypes.add(goTypes.getGhidraDataType(outParamType));
            }
            returnDT = goTypes.getFuncMultiReturn(paramDataTypes);
        }
        funcDef.setArguments((ParameterDefinition[])params.toArray(ParameterDefinition[]::new));
        funcDef.setReturnType((DataType)returnDT);
        return structPtr;
    }

    public FunctionDefinition getFunctionSignature(GoTypeManager goTypes) throws IOException {
        FunctionDefinition fd;
        Pointer funcdefPtr;
        Structure closureStructDT;
        Pointer ptrDT;
        DataType dataType;
        FunctionDefinition funcdef;
        DataType dt = goTypes.getGhidraDataType(this);
        FunctionDefinition functionDefinition = funcdef = dt instanceof Pointer && (dataType = (ptrDT = (Pointer)dt).getDataType()) instanceof Structure && (closureStructDT = (Structure)dataType).getNumComponents() > 1 && (dataType = closureStructDT.getComponent(0).getDataType()) instanceof Pointer && (dataType = (funcdefPtr = (Pointer)dataType).getDataType()) instanceof FunctionDefinition ? (fd = (FunctionDefinition)dataType) : null;
        if (funcdef == null) {
            throw new IOException("Unable to extract function sig for " + this.toString());
        }
        ArrayList<ParameterDefinition> newArgs = new ArrayList<ParameterDefinition>();
        ParameterDefinition[] oldArgs = funcdef.getArguments();
        for (int i = 1; i < oldArgs.length; ++i) {
            newArgs.add(oldArgs[i]);
        }
        FunctionDefinitionDataType funcsig = new FunctionDefinitionDataType(funcdef.getName(), goTypes.getDTM());
        try {
            funcsig.setCallingConvention(funcdef.getCallingConventionName());
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        funcsig.setReturnType(funcdef.getReturnType());
        funcsig.setArguments((ParameterDefinition[])newArgs.toArray(ParameterDefinition[]::new));
        return funcsig;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        for (GoType paramType : this.getParamTypes()) {
            if (paramType == null) continue;
            paramType.discoverGoTypes(discoveredTypes);
        }
        return true;
    }

    @Override
    protected String getTypeDeclString() throws IOException {
        String baseTypeName = this.getSymbolName().getBaseTypeName();
        String declStr = this.getFuncPrototypeString(null);
        return baseTypeName.startsWith("func(") ? "type %s".formatted(declStr) : "type %s %s".formatted(baseTypeName, declStr);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.typ.getSize() == (long)this.programContext.getPtrSize();
    }
}

