/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.DefaultRowColLocation;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import generic.theme.GThemeDefaults;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.OpenCloseField;
import ghidra.app.util.viewer.proxy.EmptyProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class IndentField
implements ListingField {
    private FieldFactory factory;
    private int startX;
    private int startY;
    private int fieldWidth;
    private int height;
    private int heightAbove;
    private ProxyObj proxy;
    private boolean isLast;
    private int indentLevel;
    private int toggleHandleSize;
    private int insetSpace = 1;

    public IndentField(FieldFactory factory, ProxyObj proxy, int indentLevel, FontMetrics metrics, int x, int width, boolean isLast) {
        this.factory = factory;
        this.proxy = proxy;
        this.fieldWidth = width;
        this.startX = x;
        this.isLast = isLast;
        this.indentLevel = indentLevel;
        this.heightAbove = metrics.getAscent();
        this.height = metrics.getLeading() + metrics.getAscent() + metrics.getDescent();
        this.toggleHandleSize = OpenCloseField.getOpenCloseHandleSize();
    }

    @Override
    public FieldFactory getFieldFactory() {
        return this.factory;
    }

    public ProxyObj getProxy() {
        if (this.proxy == null) {
            return EmptyProxy.EMPTY_PROXY;
        }
        return this.proxy;
    }

    public int getHeightAbove() {
        return this.heightAbove;
    }

    public int getHeightBelow() {
        return this.height - this.heightAbove;
    }

    public void setYPos(int yPos, int heightAbove, int heightBelow) {
        this.startY = yPos;
        this.height = heightAbove + heightBelow;
        this.heightAbove = heightAbove;
    }

    public int getWidth() {
        return (this.indentLevel + 1) * this.fieldWidth;
    }

    public int getPreferredWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public void setStartY(int startY) {
        this.startY = startY;
    }

    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager map, RowColLocation cursorLoc, int rowHeight) {
        g.setColor((Color)GThemeDefaults.Colors.Palette.LIGHT_GRAY);
        int fieldTopY = -this.heightAbove;
        int fieldBottomY = this.getHeightBelow();
        int toggleHandleHalfLength = this.toggleHandleSize / 2;
        for (int i = 1; i < this.indentLevel; ++i) {
            int fieldOffset = i * this.fieldWidth;
            int previousButtonStartX = this.startX + fieldOffset + this.insetSpace;
            int midpointX = previousButtonStartX + toggleHandleHalfLength;
            g.drawLine(midpointX, fieldTopY, midpointX, fieldBottomY);
        }
        int toggleHandleStartX = this.startX + this.indentLevel * this.fieldWidth + this.insetSpace;
        int midPointX = toggleHandleStartX + toggleHandleHalfLength;
        int midPointY = fieldTopY / 2;
        g.drawLine(midPointX, midPointY, this.startX + (this.indentLevel + 1) * this.fieldWidth, midPointY);
        g.drawLine(midPointX, fieldTopY, midPointX, midPointY);
        if (!this.isLast) {
            g.drawLine(midPointX, midPointY, midPointX, fieldBottomY);
        }
        this.paintCursor(g, context.getCursorColor(), cursorLoc);
    }

    private void paintCursor(Graphics g, Color cursorColor, RowColLocation cursorLoc) {
        if (cursorLoc != null) {
            g.setColor(cursorColor);
            Rectangle cursorBounds = this.getCursorBounds(cursorLoc.row(), cursorLoc.col());
            if (cursorBounds != null) {
                g.fillRect(cursorBounds.x, cursorBounds.y, cursorBounds.width, cursorBounds.height);
            }
        }
    }

    public boolean contains(int x, int y) {
        return x >= this.startX && x < this.startX + this.fieldWidth && y >= this.startY && y < this.startY + this.height;
    }

    public int getNumDataRows() {
        return 1;
    }

    public int getNumRows() {
        return 1;
    }

    public int getNumCols(int row) {
        return 0;
    }

    public int getX(int row, int col) {
        return this.startX;
    }

    public int getY(int row) {
        return this.startY;
    }

    public int getRow(int y) {
        return 0;
    }

    public int getCol(int row, int x) {
        return 0;
    }

    public boolean isValid(int row, int col) {
        return row == 0 && col == 0;
    }

    public Rectangle getCursorBounds(int row, int col) {
        if (!this.isValid(row, col)) {
            return null;
        }
        return new Rectangle(this.startX, -this.heightAbove, 2, this.height);
    }

    public int getScrollableUnitIncrement(int topOfScreen, int direction, int max) {
        if (topOfScreen < this.startY || topOfScreen > this.startY + this.height) {
            return max;
        }
        if (direction > 0) {
            return this.height - (topOfScreen - this.startY);
        }
        return this.startY - topOfScreen;
    }

    public boolean isPrimary() {
        return false;
    }

    public void rowHeightChanged(int newHeightAbove, int newHeightBelow) {
        this.heightAbove = newHeightAbove;
        this.height = newHeightAbove + newHeightBelow;
    }

    public String getText() {
        return "";
    }

    public String getTextWithLineSeparators() {
        return "";
    }

    public RowColLocation textOffsetToScreenLocation(int textOffset) {
        return new DefaultRowColLocation();
    }

    public int screenLocationToTextOffset(int row, int col) {
        return 0;
    }

    @Override
    public Object getClickedObject(FieldLocation fieldLocation) {
        return this;
    }
}

