/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PubSecKeyOptionsConverter;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class PubSecKeyOptions {
    private String algorithm;
    private Buffer buffer;
    private String id;
    private boolean certificate;
    private Boolean symmetric;
    private String publicKey;
    private String secretKey;

    public PubSecKeyOptions() {
    }

    public PubSecKeyOptions(PubSecKeyOptions other) {
        this.algorithm = other.algorithm;
        this.buffer = other.buffer == null ? null : other.buffer.copy();
        this.id = other.getId();
        this.publicKey = other.getPublicKey();
        this.secretKey = other.getSecretKey();
        this.symmetric = other.isSymmetric();
        this.certificate = other.isCertificate();
    }

    public PubSecKeyOptions(JsonObject json) {
        PubSecKeyOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        PubSecKeyOptionsConverter.toJson(this, json);
        return json;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public PubSecKeyOptions setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    @GenIgnore(value={"permitted-type"})
    public PubSecKeyOptions setBuffer(String buffer) {
        this.buffer = Buffer.buffer((String)buffer, (String)"UTF-8");
        return this;
    }

    public PubSecKeyOptions setBuffer(Buffer buffer) {
        this.buffer = buffer;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public PubSecKeyOptions setId(String id) {
        this.id = id;
        return this;
    }

    @Deprecated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Deprecated
    public PubSecKeyOptions setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Deprecated
    public String getSecretKey() {
        return this.secretKey;
    }

    @Deprecated
    public PubSecKeyOptions setSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @Deprecated
    public boolean isSymmetric() {
        if (this.symmetric == null) {
            return this.algorithm.startsWith("HS") && this.publicKey == null && this.secretKey != null;
        }
        return this.symmetric;
    }

    @Deprecated
    public PubSecKeyOptions setSymmetric(boolean symmetric) {
        this.symmetric = symmetric;
        return this;
    }

    @Deprecated
    public boolean isCertificate() {
        return this.certificate;
    }

    @Deprecated
    public PubSecKeyOptions setCertificate(boolean certificate) {
        this.certificate = certificate;
        return this;
    }
}

