/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.frontend.action.SendShortcutToTerminalAction;
import com.intellij.terminal.frontend.view.TerminalAllowedActionsProvider;
import com.intellij.terminal.frontend.view.impl.TerminalEventsHandler;
import com.intellij.terminal.frontend.view.impl.TerminalEventsHandlerKt;
import com.intellij.terminal.frontend.view.impl.TimedKeyEvent;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0018J\u0006\u0010\u001b\u001a\u00020\u0018J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalEventDispatcher;", "Lcom/intellij/ide/IdeEventQueue$EventDispatcher;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "eventsHandler", "Lcom/intellij/terminal/frontend/view/impl/TerminalEventsHandler;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lcom/intellij/terminal/frontend/view/impl/TerminalEventsHandler;Lcom/intellij/openapi/Disposable;)V", "sendShortcutAction", "Lcom/intellij/terminal/frontend/action/SendShortcutToTerminalAction;", "myRegistered", "", "allowedActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "ignoreNextKeyTypedEvent", "dispatch", "e", "Ljava/awt/AWTEvent;", "dispatchKeyEvent", "", "Lcom/intellij/terminal/frontend/view/impl/TimedKeyEvent;", "registerIfNeeded", "unregisterIfRegistered", "isAllowedActionShortcut", "Ljava/awt/event/KeyEvent;", "getAllowedActionIds", "", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalEventDispatcher.kt\ncom/intellij/terminal/frontend/view/impl/TerminalEventDispatcher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,348:1\n67#2,4:349\n67#2,4:353\n67#2,4:357\n67#2,2:374\n70#2:380\n67#2,4:381\n13#2:390\n1617#3,9:361\n1869#3:370\n1870#3:372\n1626#3:373\n1563#3:376\n1634#3,3:377\n1460#3,5:385\n1#4:371\n*S KotlinDebug\n*F\n+ 1 TerminalEventDispatcher.kt\ncom/intellij/terminal/frontend/view/impl/TerminalEventDispatcher\n*L\n81#1:349,4\n86#1:353,4\n94#1:357,4\n114#1:374,2\n114#1:380\n125#1:381,4\n246#1:390\n104#1:361,9\n104#1:370\n104#1:372\n104#1:373\n114#1:376\n114#1:377,3\n149#1:385,5\n104#1:371\n*E\n"})
final class TerminalEventDispatcher
implements IdeEventQueue.EventDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalEventsHandler eventsHandler;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final SendShortcutToTerminalAction sendShortcutAction;
    private boolean myRegistered;
    @NotNull
    private List<? extends AnAction> allowedActions;
    private boolean ignoreNextKeyTypedEvent;
    @Language(value="devkit-action-id")
    @NonNls
    @NotNull
    private static final List<String> ALLOWED_ACTION_IDS;
    @NotNull
    private static final Logger LOG;

    public TerminalEventDispatcher(@NotNull EditorEx editor, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalEventsHandler eventsHandler, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)eventsHandler, (String)"eventsHandler");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.editor = editor;
        this.settings = settings;
        this.eventsHandler = eventsHandler;
        this.parentDisposable = parentDisposable;
        this.sendShortcutAction = new SendShortcutToTerminalAction(this.eventsHandler);
        this.allowedActions = CollectionsKt.emptyList();
        this.ignoreNextKeyTypedEvent = true;
    }

    public boolean dispatch(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof KeyEvent) {
            TimedKeyEvent timedEvent = new TimedKeyEvent((KeyEvent)e, null, 2, null);
            this.dispatchKeyEvent(timedEvent);
        }
        return false;
    }

    private final void dispatchKeyEvent(TimedKeyEvent e) {
        Logger logger;
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Key event received: " + e.getOriginal());
        }
        if (this.isAllowedActionShortcut(e.getOriginal())) {
            this.ignoreNextKeyTypedEvent = true;
            $this$trace$iv = LOG;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Key event skipped (there is an action for it): " + e.getOriginal());
            }
        } else if (e.getOriginal().getID() != 400 || !this.ignoreNextKeyTypedEvent) {
            this.ignoreNextKeyTypedEvent = false;
            TerminalEventsHandlerKt.handleKeyEvent(this.eventsHandler, e);
        } else {
            $this$trace$iv = LOG;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Key event skipped (key typed ignored): " + e.getOriginal());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void registerIfNeeded() {
        List actions;
        void $this$mapNotNullTo$iv$iv;
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.settings.overrideIdeShortcuts()) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        Iterable $this$mapNotNull$iv = this.getAllowedActionIds();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AnAction it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl4 = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (actionManager.getAction(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        this.allowedActions = actions = (List)destination$iv$iv;
        if (!this.myRegistered) {
            IdeEventQueue.Companion.getInstance().addDispatcher((IdeEventQueue.EventDispatcher)this, this.parentDisposable);
            JComponent jComponent = this.editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            this.sendShortcutAction.register$intellij_terminal_frontend(jComponent, actions);
            this.myRegistered = true;
            this.ignoreNextKeyTypedEvent = true;
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                void $this$mapTo$iv$iv;
                Logger logger = $this$trace$iv;
                boolean bl = false;
                Iterable $this$map$iv = actions;
                boolean $i$f$map = false;
                $this$forEach$iv$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AnAction bl4 = (AnAction)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl5 = false;
                    collection.add(it.getClass().getName());
                }
                logger.trace("Dispatcher registered: start capturing key events. Allowed actions: " + (List)destination$iv$iv2);
            }
        }
    }

    public final void unregisterIfRegistered() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myRegistered) {
            IdeEventQueue.Companion.getInstance().removeDispatcher((IdeEventQueue.EventDispatcher)this);
            JComponent jComponent = this.editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            this.sendShortcutAction.unregister$intellij_terminal_frontend(jComponent);
            this.allowedActions = CollectionsKt.emptyList();
            this.myRegistered = false;
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Dispatcher unregistered: finish capturing key events");
            }
        }
    }

    private final boolean isAllowedActionShortcut(KeyEvent e) {
        KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
        for (AnAction anAction : this.allowedActions) {
            Shortcut[] shortcutArray;
            Intrinsics.checkNotNullExpressionValue((Object)anAction.getShortcutSet().getShortcuts(), (String)"getShortcuts(...)");
            for (Shortcut sc : shortcutArray) {
                if (!sc.isKeyboard() || !sc.startsWith((Shortcut)eventShortcut)) continue;
                return Registry.Companion.is("terminal.Ctrl-E.opens.RecentFiles.popup", false) || !Intrinsics.areEqual((Object)"RecentFiles", (Object)ActionManager.getInstance().getId(anAction)) || e.getModifiersEx() != 128 || e.getKeyCode() != 69;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAllowedActionIds() {
        void $this$flatMapTo$iv;
        LinkedHashSet actionIds = new LinkedHashSet(ALLOWED_ACTION_IDS);
        Iterable iterable = TerminalAllowedActionsProvider.Companion.getEP_NAME$intellij_terminal_frontend().getExtensionList();
        Collection destination$iv = actionIds;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            TerminalAllowedActionsProvider it = (TerminalAllowedActionsProvider)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getActionIds();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return CollectionsKt.toList((Iterable)actionIds);
    }

    static {
        Object[] objectArray = new String[]{"ActivateTerminalToolWindow", "ActivateProjectToolWindow", "ActivateFavoritesToolWindow", "ActivateBookmarksToolWindow", "ActivateFindToolWindow", "ActivateRunToolWindow", "ActivateDebugToolWindow", "ActivateProblemsViewToolWindow", "ActivateTODOToolWindow", "ActivateStructureToolWindow", "ActivateHierarchyToolWindow", "ActivateServicesToolWindow", "ActivateCommitToolWindow", "ActivateVersionControlToolWindow", "HideActiveWindow", "HideAllWindows", "NextWindow", "PreviousWindow", "NextProjectWindow", "PreviousProjectWindow", "ShowBookmarks", "ShowTypeBookmarks", "FindInPath", "GotoBookmark0", "GotoBookmark1", "GotoBookmark2", "GotoBookmark3", "GotoBookmark4", "GotoBookmark5", "GotoBookmark6", "GotoBookmark7", "GotoBookmark8", "GotoBookmark9", "GotoAction", "GotoFile", "GotoClass", "GotoSymbol", "Vcs.Push", "ShowSettings", "RecentFiles", "Switcher", "ResizeToolWindowLeft", "ResizeToolWindowRight", "ResizeToolWindowUp", "ResizeToolWindowDown", "MaximizeToolWindow", "NextTab", "PreviousTab", "ShowContent", "TW.CloseOtherTabs", "TW.CloseAllTabs", "TW.SplitRight", "TW.SplitDown", "TW.SplitAndMoveRight", "TW.SplitAndMoveDown", "TW.Unsplit", "TW.MoveToNextSplitter", "TW.MoveToPreviousSplitter", "TerminalIncreaseFontSize", "TerminalDecreaseFontSize", "TerminalResetFontSize", "Terminal.MoveToEditor", "Terminal.Escape", "Terminal.CopySelectedText", "Terminal.Paste", "Terminal.LineUp", "Terminal.LineDown", "Terminal.PageUp", "Terminal.PageDown", "Terminal.RenameSession", "Terminal.NewTab", "Terminal.CloseTab", "Terminal.MoveToolWindowTabLeft", "Terminal.MoveToolWindowTabRight", "Terminal.ClearBuffer", "Terminal.Find", "Terminal.CommandCompletion.Invoke", "Terminal.CommandCompletion.InsertSuggestion", "Terminal.CommandCompletion.SelectSuggestionAbove", "Terminal.CommandCompletion.SelectSuggestionBelow", "Terminal.InsertInlineCompletion"};
        ALLOWED_ACTION_IDS = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalEventDispatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalEventDispatcher$Companion;", "", "<init>", "()V", "ALLOWED_ACTION_IDS", "", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

