/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.util.regex;

import ai.grazie.rules.util.regex.CharClass;
import ai.grazie.rules.util.regex.CharRange;
import ai.grazie.rules.util.regex.Concat;
import ai.grazie.rules.util.regex.Literal;
import ai.grazie.rules.util.regex.Or;
import ai.grazie.rules.util.regex.PathComponent;
import ai.grazie.rules.util.regex.Postfix;
import ai.grazie.rules.util.regex.Term;
import ai.grazie.rules.util.regex.Unsupported;
import java.util.ArrayList;

class RegexParser {
    private final String regex;
    private int pos;

    RegexParser(String regex) {
        if (regex.startsWith("^")) {
            regex = regex.substring(1);
        }
        if (regex.endsWith("$") && !regex.endsWith("\\$")) {
            regex = regex.substring(0, regex.length() - 1);
        }
        this.regex = regex;
    }

    Term parse() {
        Term term = this.parseOr();
        if (this.pos != this.regex.length()) {
            throw new IllegalArgumentException("Unexpected characters at the end of regex starting at position " + this.pos);
        }
        return term;
    }

    private Term parseOr() {
        ArrayList<Term> components = new ArrayList<Term>();
        while (this.pos < this.regex.length()) {
            components.add(this.parseConcat());
            if (this.pos >= this.regex.length() || this.regex.charAt(this.pos) != '|') break;
            ++this.pos;
            if (this.pos != this.regex.length()) continue;
            components.add(new Literal(""));
        }
        return components.isEmpty() ? new Literal("") : (components.size() == 1 ? (Term)components.get(0) : new Or(components));
    }

    private Term parseConcat() {
        ArrayList<Term> result = new ArrayList<Term>();
        while (this.pos < this.regex.length() && this.regex.charAt(this.pos) != '|' && this.regex.charAt(this.pos) != ')') {
            Object e;
            Term next = this.applyPostfix(this.parseTerm());
            if (!result.isEmpty() && (e = result.get(result.size() - 1)) instanceof PathComponent) {
                PathComponent f2;
                PathComponent merged;
                PathComponent f1 = (PathComponent)e;
                if (next instanceof PathComponent && (merged = f1.merge(f2 = (PathComponent)next)) != null) {
                    result.set(result.size() - 1, merged);
                    continue;
                }
            }
            result.add(next);
        }
        return result.isEmpty() ? new Literal("") : (result.size() == 1 ? (Term)result.get(0) : new Concat(result));
    }

    private Term applyPostfix(Term term) {
        if (this.pos < this.regex.length()) {
            char c = this.regex.charAt(this.pos);
            if (c == '*' || c == '+' || c == '?') {
                ++this.pos;
                if (term instanceof Unsupported) {
                    Unsupported u = (Unsupported)term;
                    return new Unsupported(c == '+' ? u.minLength() : 0, c == '?' && u.bounded(), u.anyChars());
                }
                return new Postfix(term, String.valueOf(c));
            }
            if (c == '{') {
                int start = this.pos;
                this.pos = this.regex.indexOf(125, this.pos) + 1;
                if (this.pos <= 0) {
                    throw new IllegalArgumentException("Unmatched '{' at position " + start);
                }
                if (term instanceof Unsupported) {
                    return new Unsupported(0, false, false);
                }
                return new Postfix(term, this.regex.substring(start, this.pos));
            }
        }
        return term;
    }

    private Term parseTerm() {
        char c = this.regex.charAt(this.pos);
        if (c == '(') {
            return this.parseGroup();
        }
        if (c == '[') {
            return this.parseCharClass();
        }
        if (c == '\\') {
            ++this.pos;
            if (this.pos >= this.regex.length()) {
                throw new IllegalArgumentException("Unexpected end of regex after backslash at position " + this.pos);
            }
            return this.parseAfterSlash();
        }
        if (c == '.') {
            ++this.pos;
            return new Unsupported(1, true, true);
        }
        return this.parseLiteral();
    }

    private Term parseAfterSlash() {
        char escaped = this.regex.charAt(this.pos++);
        return switch (escaped) {
            case 'D', 'S', 'W', 'd', 's', 'w' -> new Unsupported(1, true, false);
            case 'P', 'p' -> this.parseUnicodeProperty();
            case 'u' -> {
                this.pos += 4;
                yield new Unsupported(1, true, false);
            }
            default -> new Literal(String.valueOf(escaped));
        };
    }

    private Term parseUnicodeProperty() {
        if (this.pos >= this.regex.length() || this.regex.charAt(this.pos) != '{') {
            throw new IllegalArgumentException("Incomplete Unicode property escape \\p at position " + this.pos);
        }
        int start = this.pos;
        this.pos = this.regex.indexOf(125, this.pos + 1) + 1;
        if (this.pos <= 0) {
            throw new IllegalArgumentException("Unterminated Unicode property at position " + start);
        }
        return new Unsupported(1, true, false);
    }

    private Term parseGroup() {
        int start = this.pos++;
        boolean unsupported = false;
        if (this.regex.charAt(this.pos) == '?') {
            ++this.pos;
            if (this.regex.charAt(this.pos) == ':') {
                ++this.pos;
            } else {
                unsupported = true;
            }
        }
        Term inner = this.parseOr();
        if (this.pos >= this.regex.length() || this.regex.charAt(this.pos) != ')') {
            throw new IllegalArgumentException("Unmatched parenthesis starting at position " + start);
        }
        ++this.pos;
        return unsupported ? new Unsupported(0, false, false) : inner;
    }

    private Term parseCharClass() {
        boolean negated;
        ++this.pos;
        ArrayList<Character> singleChars = new ArrayList<Character>();
        ArrayList<CharRange> ranges = new ArrayList<CharRange>();
        int start = this.pos;
        boolean bl = negated = this.regex.charAt(this.pos) == '^';
        if (negated) {
            ++this.pos;
        }
        boolean unsupported = negated;
        int nesting = 0;
        while (this.pos < this.regex.length()) {
            char c;
            if ((c = this.regex.charAt(this.pos++)) == '\\') {
                Term term = this.parseAfterSlash();
                if (term instanceof Literal) {
                    Literal l = (Literal)term;
                    assert (l.value().length() == 1);
                    singleChars.add(Character.valueOf(l.value().charAt(0)));
                    continue;
                }
                unsupported = true;
                continue;
            }
            if (c == '[') {
                ++nesting;
                unsupported = true;
                continue;
            }
            if (c == ']' && this.pos != start + 1) {
                if (nesting > 0) {
                    --nesting;
                    continue;
                }
                return unsupported ? new Unsupported(1, true, false) : new CharClass(singleChars, ranges);
            }
            if (this.regex.charAt(this.pos) == '-' && this.pos + 1 < this.regex.length() && this.regex.charAt(this.pos + 1) != ']') {
                ranges.add(new CharRange(c, this.regex.charAt(this.pos + 1)));
                ++this.pos;
                continue;
            }
            singleChars.add(Character.valueOf(c));
        }
        throw new IllegalArgumentException("Unmatched '[' starting at position " + (this.pos - 1));
    }

    private Term parseLiteral() {
        char c;
        StringBuilder sb = new StringBuilder();
        while (this.pos < this.regex.length() && "()[|\\.".indexOf(c = this.regex.charAt(this.pos)) < 0) {
            if ("*+?{".indexOf(c) >= 0) {
                if (sb.length() <= 1) break;
                sb.setLength(sb.length() - 1);
                --this.pos;
                break;
            }
            sb.append(this.regex.charAt(this.pos++));
        }
        return new Literal(sb.toString());
    }
}

